import sys

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # RANDOM for specific ranges known to be expensive
        use_random = (
            (100000 <= x <= 999999 and step_count == 1) or
            (x > 3000000 and step_count <= 2)
        )

        if use_random:
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())
        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

def main():
    t = int(input().strip())
    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()