import sys

def count_digits(n):
    return len(str(n))

def solve_one_number(x0):
    x = x0
    step_count = 0

    while x != 1:
        step_count += 1

        # MIDDLE strategy: balanced random usage
        digits = count_digits(x)

        use_random = (
            # For 5+ digit numbers, use random periodically
            (digits >= 5 and step_count % 12 == 0) or
            # For very large numbers, more frequent
            (digits >= 6 and step_count % 8 == 0) or
            # When stuck for long time
            (step_count > 80 and step_count % 25 == 0)
        )

        if use_random:
            print("random")
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())
        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            x = result

def main():
    t = int(input().strip())
    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()