import sys

def count_digits(n):
    return len(str(n))

def solve_one_number(x0):
    x = x0
    step_count = 0
    last_x = x0
    increases = 0  # Count consecutive increases

    while x != 1:
        step_count += 1

        # Track if number is growing (bad sign)
        if x > last_x:
            increases += 1
        else:
            increases = 0

        # Use RANDOM when:
        # 1. Number keeps growing (stuck in expensive trajectory)
        # 2. Number is large enough to benefit from jump
        # 3. But not too large (would make things worse)
        use_random = (
            increases >= 3 and           # Growing for 3+ steps
            count_digits(x) >= 4 and     # At least 4 digits
            count_digits(x) <= 7 and     # But not too many digits
            step_count % 10 == 0         # Not too often
        )

        if use_random:
            print("random")
            increases = 0  # Reset after using random
        else:
            print("collatz")

        sys.stdout.flush()

        result = int(input().strip())

        if result == 0:
            return False
        elif result == 1:
            return True
        else:
            last_x = x
            x = result

def main():
    t = int(input().strip())

    for _ in range(t):
        x0 = int(input().strip())
        success = solve_one_number(x0)
        if not success:
            break

if __name__ == "__main__":
    main()