def solve():
    n, s = map(int, input().split())
    
    # Используем set для быстрого поиска O(1)
    V = set()
    
    for _ in range(n):
        # Обновляем s по формуле
        s = (s * 618023 + 1) % 999983
        
        # Подсчитываем количество пар (a,b) где a + b = s и a <= b
        pair_count = 0
        
        # Оптимизация: проходим только по элементам <= s//2
        # чтобы избежать дублирования пар
        for a in V:
            if a > s // 2:
                break
            b = s - a
            if b in V:
                pair_count += 1
        
        # Если количество пар четное, добавляем s в V
        if pair_count % 2 == 0:
            V.add(s)
    
    return len(V)

if __name__ == "__main__":
    print(solve())
