class Fraction:
    def __init__(self, num, den=1):
        self.num = num
        self.den = den
        self._reduce()

    def _gcd(self, a, b):
        while b:
            a, b = b, a % b
        return a

    def _reduce(self):
        g = self._gcd(abs(self.num), abs(self.den))
        self.num //= g
        self.den //= g
        if self.den < 0:
            self.num, self.den = -self.num, -self.den

    def __add__(self, other):
        if isinstance(other, (int, float)):
            other = Fraction(other)
        return Fraction(self.num * other.den + other.num * self.den, self.den * other.den)

    def __mul__(self, other):
        if isinstance(other, (int, float)):
            other = Fraction(other)
        return Fraction(self.num * other.num, self.den * other.den)

    def __truediv__(self, other):
        if isinstance(other, (int, float)):
            other = Fraction(other)
        return Fraction(self.num * other.den, self.den * other.num)

def modinv(a, mod):
    """Compute modular inverse of a modulo mod using Fermat's little theorem"""
    return pow(a, mod - 2, mod)

def solve():
    MOD = 10**9 + 7

    t = int(input())
    for _ in range(t):
        p, m = map(int, input().split())

        if p == 0:
            print(0)
            continue

        # Use dynamic programming with memoization
        # State: (pairs_started, singles_drawn)
        # pairs_started = number of pairs where we've drawn exactly one sock
        # singles_drawn = number of single socks we've drawn

        memo = {}

        def expected_draws(pairs_started, singles_drawn):
            if (pairs_started, singles_drawn) in memo:
                return memo[(pairs_started, singles_drawn)]

            remaining_socks = 2 * p + m - pairs_started - singles_drawn

            if remaining_socks <= 0:
                return Fraction(0)

            # If we have pairs_started > 0, we might complete a pair
            if pairs_started > 0:
                # Probability of completing a pair
                prob_complete = Fraction(pairs_started, remaining_socks)
                if pairs_started == remaining_socks:
                    # Must complete a pair
                    memo[(pairs_started, singles_drawn)] = Fraction(1)
                    return Fraction(1)

            result = Fraction(1)  # We draw one sock for sure

            # Case 1: Draw a new single sock
            if singles_drawn < m:
                prob_single = Fraction(m - singles_drawn, remaining_socks)
                result = result + prob_single * expected_draws(pairs_started, singles_drawn + 1)

            # Case 2: Start a new pair
            if pairs_started < p:
                prob_new_pair = Fraction(2 * (p - pairs_started), remaining_socks)
                result = result + prob_new_pair * expected_draws(pairs_started + 1, singles_drawn)

            # Case 3: Complete an existing pair (game ends, so adds 0 to expectation)
            # This is already accounted for in the "1" we add above

            memo[(pairs_started, singles_drawn)] = result
            return result

        expected_frac = expected_draws(0, 0)

        # Convert fraction to modular arithmetic
        result = (expected_frac.num * modinv(expected_frac.den, MOD)) % MOD
        print(result)

solve()