def modinv(a, mod):
    """Compute modular inverse of a modulo mod using Fermat's little theorem"""
    return pow(a, mod - 2, mod)

def solve():
    MOD = 10**9 + 7
    
    t = int(input())
    for _ in range(t):
        p, m = map(int, input().split())
        
        if p == 0:
            print(0)
            continue
        
        # Fast iterative DP: process states by total socks drawn
        total_socks = 2 * p + m
        dp = {}
        
        # Process states in reverse order (from most socks drawn to least)
        for socks_drawn in range(total_socks, -1, -1):
            for pairs_started in range(min(p + 1, socks_drawn + 1)):
                singles_drawn = socks_drawn - pairs_started
                if singles_drawn > m or singles_drawn < 0:
                    continue
                
                remaining_socks = total_socks - socks_drawn
                
                if remaining_socks <= 0:
                    dp[(pairs_started, singles_drawn)] = 0
                elif pairs_started > 0 and pairs_started == remaining_socks:
                    dp[(pairs_started, singles_drawn)] = 1
                else:
                    # We draw one sock for sure
                    result = 1
                    
                    # Case 1: Draw a new single sock
                    if singles_drawn < m:
                        prob_single = (m - singles_drawn) * modinv(remaining_socks, MOD) % MOD
                        next_state = (pairs_started, singles_drawn + 1)
                        if next_state in dp:
                            result = (result + prob_single * dp[next_state]) % MOD
                    
                    # Case 2: Start a new pair
                    if pairs_started < p:
                        prob_new_pair = (2 * (p - pairs_started)) * modinv(remaining_socks, MOD) % MOD
                        next_state = (pairs_started + 1, singles_drawn)
                        if next_state in dp:
                            result = (result + prob_new_pair * dp[next_state]) % MOD
                    
                    dp[(pairs_started, singles_drawn)] = result
        
        print(dp.get((0, 0), 0))

solve()