#include <iostream>
using namespace std;

const int MOD = 1e9 + 7;
const int MAX_N = 2000001;
const int MAX_P = 1000000;

long long fact[MAX_N + 1];
long long inv_fact[MAX_N + 1];
long long pow4[MAX_P + 1];

long long mod_pow(long long base, long long exp, long long mod) {
    long long result = 1;
    while (exp > 0) {
        if (exp % 2 == 1) {
            result = (result * base) % mod;
        }
        base = (base * base) % mod;
        exp /= 2;
    }
    return result;
}

void precompute() {
    fact[0] = 1;
    for (int i = 1; i <= MAX_N; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }

    inv_fact[MAX_N] = mod_pow(fact[MAX_N], MOD - 2, MOD);
    for (int i = MAX_N - 1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }

    pow4[0] = 1;
    for (int i = 1; i <= MAX_P; i++) {
        pow4[i] = pow4[i - 1] * 4 % MOD;
    }
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    precompute();

    int t;
    cin >> t;

    while (t--) {
        int p, m;
        cin >> p >> m;

        long long term1 = (2LL * p + m + 1) % MOD;
        long long term2 = pow4[p];
        long long term3 = fact[p] * fact[p] % MOD;
        long long numerator = term1 * term2 % MOD * term3 % MOD;
        long long denominator = fact[2 * p + 1];

        long long ans = numerator * inv_fact[2 * p + 1] % MOD;

        cout << ans << '\n';
    }

    return 0;
}