#include <cstdio>
#include <cmath>
#include <vector>
#include <string>
#include <functional>

struct Point final {
	int x = 0, y = 0;
};

struct Output final {
	long long a, b, c1, c2;

	Output&& output() && {
		printf("%lld %lld %lld\n%lld %lld %lld\n", a, b, c1, a, b, c2);
		fflush(stdout);
		return std::move(*this);
	}
};

struct Input final {
	size_t n;
	std::vector<Point> points;

	Input() {
		scanf("%llu", &n);
		for (uint32_t i = 0; i < n; ++i) {
			Point& p = points.emplace_back();
			scanf("%d %d", &p.x, &p.y);
		}
	}

	Output solve() && {
		Point min, max;
		uint64_t best = 0;
		for (size_t i = 0; i < n; ++i) {
			for (size_t j = i + 1; j < n; ++j) {
				Point a = points[i], b = points[j];
				uint64_t d = (a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y);
				if (d > best) {
					best = d;
					min = a;
					max = b;
				}
			}
		}
		if (min.x > max.y)
			std::swap(min, max);
		Point norm { .x = max.x - min.x, .y = max.y - min.y };
		Point dir { .x = -norm.y, .y = norm.x };
		return Output { .a = dir.y, .b = -dir.x, .c1 = dir.x * min.y - dir.y * min.x, .c2 = dir.x * max.y - dir.y * max.x };
	}
};

int main() {
	Input{ }.solve().output();

	return 0;
}