#include <iostream>
#include <vector>
#include <algorithm>
using namespace std;

const int MOD = 1e9 + 7;
const int PRE_N = 100000;

vector<long long> fact(PRE_N + 1), inv_fact(PRE_N + 1);
vector<long long> pow2(PRE_N + 1);

bool precomputed = false;

long long mod_pow(long long a, long long b, int mod) {
    long long r = 1;
    while (b) {
        if (b & 1) r = r * a % mod;
        a = a * a % mod;
        b >>= 1;
    }
    return r;
}

void precompute() {
    if (precomputed) return;

    fact[0] = 1;
    for (int i = 1; i <= PRE_N; i++) {
        fact[i] = fact[i - 1] * i % MOD;
    }

    inv_fact[PRE_N] = mod_pow(fact[PRE_N], MOD - 2, MOD);
    for (int i = PRE_N - 1; i >= 0; i--) {
        inv_fact[i] = inv_fact[i + 1] * (i + 1) % MOD;
    }

    pow2[0] = 1;
    for (int i = 1; i <= PRE_N; i++) {
        pow2[i] = pow2[i - 1] * 2 % MOD;
    }
    
    precomputed = true;
}

long long binom(int n, int k) {
    if (k < 0 || k > n) return 0;
    return fact[n] * inv_fact[k] % MOD * inv_fact[n - k] % MOD;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    
    precompute();
    
    int z;
    cin >> z;
    while (z--) {
        int p, m;
        cin >> p >> m;
        int n = 2 * p + m;
        
        long long E = 1;
        
        for (int k = 1; k < n; k++) {
            long long chisl = 0;
            long long znam = 1;
            
            znam = fact[n] * inv_fact[n - k] % MOD;
            
            for (int t = max(0, k - m); t <= min(p, k); t++) {
                long long term = binom(p, t) * binom(m, k - t) % MOD;
                term = term * pow2[t] % MOD;
                term = term * fact[k] % MOD;
                chisl = (chisl + term) % MOD;
            }
            
            long long inv_znam = mod_pow(znam, MOD - 2, MOD);
            E = (E + chisl * inv_znam) % MOD;
        }
        
        cout << E << "\n";
    }
    
    return 0;
}