#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>

using namespace std;
using ll = long long;
const int MOD = 1e9 + 7;
const int MAXN = 3000000;

ll mod_pow(ll a, ll b) {
    ll r = 1;
    while (b) {
        if (b & 1) r = r * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return r;
}

static ll inv[MAXN + 5], fact[MAXN + 5], inv_fact[MAXN + 5];

void init() {
    fact[0] = 1;
    for (int i = 1; i <= MAXN; i++) fact[i] = fact[i - 1] * i % MOD;
    inv_fact[MAXN] = mod_pow(fact[MAXN], MOD - 2);
    for (int i = MAXN; i >= 1; i--) inv_fact[i - 1] = inv_fact[i] * i % MOD;
    inv[1] = 1;
    for (int i = 2; i <= MAXN; i++)
        inv[i] = (MOD - MOD / i) * inv[MOD % i] % MOD;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    init();

    int t;
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        int n = 2 * p + m;
        int K = p + m;

        ll P = 0;
        ll ap = 1;
        ll ac = (2LL * p + m) % MOD;

        P = (P + fact[0] * fact[n] % MOD * ap) % MOD;
        if (K >= 1)
            P = (P + fact[1] * fact[n - 1] % MOD * ac) % MOD;

        for (int i = 1; i < K; ++i) {
            ll term1 = ((2LL * p + m - 3LL * i) % MOD + MOD) % MOD;
            ll term2 = ((2LL * p + 2LL * m - 2LL * i + 2) % MOD + MOD) % MOD;
            ll an = (term1 * ac % MOD + term2 * ap % MOD) % MOD;
            an = an * inv[i + 1] % MOD;

            int k = i + 1;
            P = (P + fact[k] * fact[n - k] % MOD * an) % MOD;
            ap = ac;
            ac = an;
        }

        ll E = P * inv_fact[n] % MOD;
        cout << E << '\n';
    }
    return 0;
}
