def main():
    import sys
    data = sys.stdin.read().splitlines()
    t = int(data[0])
    melodies = [line.strip() for line in data[1:1 + t]]

    notes = "ABCDEFG"
    positions_for_letter = {}
    for i in range(52):
        letter = notes[i % 7]
        if letter not in positions_for_letter:
            positions_for_letter[letter] = []
        positions_for_letter[letter].append(i)

    results = []
    for melody in melodies:
        if not melody:
            results.append("Yes")
            continue

        current_set = set(positions_for_letter[melody[0]])
        for i in range(1, len(melody)):
            next_letter = melody[i]
            next_positions = positions_for_letter[next_letter]
            new_set = set()
            for n in next_positions:
                for d in range(-3, 4):
                    if n + d in current_set:
                        new_set.add(n)
                        break
            current_set = new_set
            if not current_set:
                results.append("No")
                break
        else:
            results.append("Yes")

    print("\n".join(results))


if __name__ == "__main__":
    main()