#include <bits/stdc++.h>
using namespace std;
using int64 = long long;
const int MOD = 1000000007;

static const int P1 = 167772161;
static const int P2 = 469762049;
static const int P3 = 1224736769;

inline int64 modpow(int64 a, int64 e, int64 mod) {
    int64 r = 1;
    while (e) {
        if (e & 1) r = (r * a) % mod;
        a = (a * a) % mod;
        e >>= 1;
    }
    return r;
}

struct NTT {
    int mod;
    int root;
    NTT(int mod_, int root_): mod(mod_), root(root_) {}

    void ntt(vector<int> & a, bool invert) {
        int n = (int)a.size();
        for (int i=1, j=0; i<n; ++i) {
            int bit = n >> 1;
            for (; j & bit; bit >>= 1) j ^= bit;
            j ^= bit;
            if (i < j) swap(a[i], a[j]);
        }
        for (int len=2; len<=n; len<<=1) {
            int64 wlen = modpow(root, (mod-1)/len, mod);
            if (invert) wlen = modpow(wlen, mod-2, mod);
            for (int i=0; i<n; i+=len) {
                int64 w = 1;
                int half = len>>1;
                for (int j=0; j<half; ++j) {
                    int64 u = a[i+j];
                    int64 v = a[i+j+half] * w % mod;
                    a[i+j] = (int)((u + v) % mod);
                    a[i+j+half] = (int)((u - v + mod) % mod);
                    w = w * wlen % mod;
                }
            }
        }
        if (invert) {
            int64 inv_n = modpow(n, mod-2, mod);
            for (int &x : a) x = (int)( (int64)x * inv_n % mod );
        }
    }

    vector<int> multiply(const vector<int> &a, const vector<int> &b) {
        if (a.empty() || b.empty()) return {};
        int n1 = (int)a.size(), n2 = (int)b.size();
        int n = 1; while (n < n1 + n2 - 1) n <<= 1;
        vector<int> fa(n), fb(n);
        for (int i=0;i<n1;++i) fa[i] = a[i] % mod;
        for (int i=0;i<n2;++i) fb[i] = b[i] % mod;
        ntt(fa, false);
        ntt(fb, false);
        for (int i=0;i<n;++i) fa[i] = (int)((int64)fa[i] * fb[i] % mod);
        ntt(fa, true);
        fa.resize(n1 + n2 - 1);
        return fa;
    }
};

int64 inv_mod(int64 a, int64 m) {
    int64 b = m, x = 1, y = 0;
    while (b) {
        int64 q = a / b;
        int64 t = a - q*b; a = b; b = t;
        t = x - q*y; x = y; y = t;
    }
    if (x < 0) x += m;
    return x;
}

int64 garner_mod(const array<int,3>& r) {
    const int64 m1 = P1, m2 = P2, m3 = P3;
    static int64 inv12 = -1, inv13 = -1, inv23 = -1;
    if (inv12 == -1) {
        inv12 = inv_mod(m1 % m2, m2); // inv of m1 mod m2
        inv13 = inv_mod(m1 % m3, m3);
        inv23 = inv_mod(m2 % m3, m3);
    }
    int64 x1 = r[0];
    int64 t = ( (r[1] - x1) % m2 + m2 ) % m2;
    t = (t * inv12) % m2;
    int64 x2 = (x1 + t * m1);

    int64 t2 = ( (r[2] - (x2 % m3)) % m3 + m3 ) % m3;
    int64 inv_m1_m3 = inv13;
    int64 inv_m2_m3 = inv23;
    int64 inv_prod = inv_m1_m3 * inv_m2_m3 % m3;
    t2 = t2 * inv_prod % m3;
    __int128 res = (__int128)x2 + (__int128)t2 * (__int128)m1 * (__int128)m2;
    int64 modAll = (int64)MOD;
    int64 ans = (int64)(res % modAll);
    if (ans < 0) ans += modAll;
    return ans;
}

struct FactMod {
    int mod;
    vector<int> fact, invfact;
    FactMod() {}
    FactMod(int nmax, int mod_): mod(mod_) {
        fact.assign(nmax+1, 1);
        invfact.assign(nmax+1, 1);
        for (int i=1;i<=nmax;++i) fact[i] = (int)((int64)fact[i-1]*i % mod);
        invfact[nmax] = (int)modpow(fact[nmax], mod-2, mod);
        for (int i=nmax; i>0; --i) invfact[i-1] = (int)((int64)invfact[i]*i % mod);
    }
    int C(int n, int k) const {
        if (k < 0 || k > n) return 0;
        return (int)((int64)fact[n] * invfact[k] % mod * invfact[n-k] % mod);
    }
};

struct FactModBig {
    int mod;
    vector<int> fact, invfact;
    FactModBig() {}
    FactModBig(int nmax): mod(MOD) {
        fact.assign(nmax+1, 1);
        invfact.assign(nmax+1, 1);
        for (int i=1;i<=nmax;++i) fact[i] = (int)((int64)fact[i-1]*i % mod);
        invfact[nmax] = (int)modpow(fact[nmax], mod-2, mod);
        for (int i=nmax; i>0; --i) invfact[i-1] = (int)((int64)invfact[i]*i % mod);
    }
    int C(int n, int k) const {
        if (k < 0 || k > n) return 0;
        return (int)((int64)fact[n] * invfact[k] % mod * invfact[n-k] % mod);
    }
    int inv(int x) const {
        return (int)modpow(x, mod-2, mod);
    }
};

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int t;
    if (!(cin >> t)) return 0;
    vector<pair<int,int>> qs(t);
    int maxP = 0, maxM = 0, maxN = 0;
    for (int i=0;i<t;++i) {
        int p,m; cin >> p >> m;
        qs[i] = {p,m};
        maxP = max(maxP, p);
        maxM = max(maxM, m);
        maxN = max(maxN, 2*p + m);
    }

    int up = max(maxP, maxM);
    int upAll = maxN;
    FactMod f1(upAll, P1);
    FactMod f2(upAll, P2);
    FactMod f3(upAll, P3);
    FactModBig fmod(upAll);

    NTT ntt1(P1, 3), ntt2(P2, 3), ntt3(P3, 3);

    for (int qi=0; qi<t; ++qi) {
        int p = qs[qi].first, m = qs[qi].second;
        int N = 2*p + m;
        vector<int> a1(p+1), b1(m+1);
        vector<int> a2(p+1), b2(m+1);
        vector<int> a3(p+1), b3(m+1);

        vector<int> pow2_p1(p+1), pow2_p2(p+1), pow2_p3(p+1);
        pow2_p1[0]=pow2_p2[0]=pow2_p3[0]=1;
        for (int i=1;i<=p;++i) {
            pow2_p1[i] = (int)((int64)pow2_p1[i-1]*2 % P1);
            pow2_p2[i] = (int)((int64)pow2_p2[i-1]*2 % P2);
            pow2_p3[i] = (int)((int64)pow2_p3[i-1]*2 % P3);
        }
        for (int t0=0; t0<=p; ++t0) {
            a1[t0] = (int)((int64)f1.C(p, t0) * pow2_p1[t0] % P1);
            a2[t0] = (int)((int64)f2.C(p, t0) * pow2_p2[t0] % P2);
            a3[t0] = (int)((int64)f3.C(p, t0) * pow2_p3[t0] % P3);
        }
        for (int s0=0; s0<=m; ++s0) {
            b1[s0] = f1.C(m, s0);
            b2[s0] = f2.C(m, s0);
            b3[s0] = f3.C(m, s0);
        }

        vector<int> c1 = ntt1.multiply(a1, b1);
        vector<int> c2 = ntt2.multiply(a2, b2);
        vector<int> c3 = ntt3.multiply(a3, b3);
        int len = (int)c1.size();

        int64 answer = 0;
        for (int k=0; k<=N-1; ++k) {
            int r1 = (k < (int)c1.size() ? c1[k] : 0);
            int r2 = (k < (int)c2.size() ? c2[k] : 0);
            int r3 = (k < (int)c3.size() ? c3[k] : 0);
            array<int,3> rem = {r1, r2, r3};
            int64 Ak_mod = garner_mod(rem);
            int denom = fmod.C(N, k);
            int denom_inv = fmod.inv(denom);
            answer += Ak_mod * denom_inv % MOD;
            if (answer >= MOD) answer -= MOD;
        }
        cout << answer % MOD << '\n';
    }
    return 0;
}
