#pragma GCC optimize("O3")

#include <iostream>
#include <vector>
#include <algorithm>
#include <cmath>
#include <set>
#include <map>
#include <queue>
#include <sstream>
#include <fstream>
#include <cassert>
#include <bitset>
#include <cinttypes>
#include <emmintrin.h>
#include <numeric>
// #include <concepts>

#include <sstream>
#include <istream>
#include <regex>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>
#include <variant>
// #include <pstl/algorithm_fwd.h>

#define optimization_lvl_GOD          \
    ios_base::sync_with_stdio(false); \
    cin.tie(nullptr);                 \
    cout.tie(nullptr)

using ll = long long;
using ull = unsigned long long;
using ld = long double;

#define YES cout << "YES\n"
#define NO cout << "NO\n"
#define line cout << "----------\n"

#define pb push_back
#define re return
#define last(x) x[x.size() - 1]

#define pll pair<ll,ll>
#define pld pair<ld,ld>

#define vec vector

#define vll vec<ll>
#define vvll vec<vll>

#define vld vec<ld>
#define vvld vec<vld>

#define vpll vec<pll>
#define vvpll vec<vpll>

#define vb vec<bool>
#define vvb vec<vb>

#define all(vec) vec.begin(), vec.end()

#define fori(firstValI, secondValI) for(ll i = firstValI; i < secondValI; ++i)
#define forj(firstValJ, secondValJ) for(ll j = firstValJ; j < secondValJ; ++j)
#define forz(firstValZ, secondValZ) for(ll z = firstValZ; z < secondValZ; ++z)

using namespace std;

template <typename T1, typename T2>
istream& operator>>(istream& is, pair<T1, T2>& p) {
    is >> p.first >> p.second;
    return is;
}

template <typename T>
istream& operator>>(istream& is, vec<T>& v) {
    for (auto &i : v) {
        is >> i;
    }
    return is;
}

template <typename T>
istream& operator>>(istream& is, vec<vec<T>>& v) {
    for (auto &i : v) {
        is >> i;
    }
    return is;
}

template <typename T1, typename T2>
ostream& operator<<(ostream& os, pair<T1, T2> &p) {
    cout << p.first << ' ' << p.second << '\n';
    return os;
}

template <typename T>
ostream& operator<<(ostream& os, vec<T> &v) {
    for (auto &i : v) {
        os << i << ' ';
    }
    return os;
}

template <typename T>
ostream& operator<<(ostream& os, vec<vec<T>> &v) {
    for (auto &i : v) {
        os << i << '\n';
    }
    return os;
}

vec<pll> moveC{{0, 1}, {0, -1}, {1, 0}, {-1, 0}};

const ll MOD = 1e9 + 7,
         inf = 1e10;
const ld PI = 3.141592653589793,
        eps = 1e-9,
        cfPI = PI / ld(180);

ll arrSum(vll arr) {
    if (arr.empty()) {
        return 0;
    }

    ll sum = 0;
    for (auto &i : arr) {
        sum += i;
    }

    return sum;
}

ll max(vll arr) {
    if (arr.empty()) {
        return -inf;
    }

    ll res = arr[0];
    for (auto &i : arr) {
        res = max(res, i);
    }

    return res;
}

ll min(vll arr) {
    if (arr.empty()) {
        return -inf;
    }

    ll res = arr[0];
    for (auto &i : arr) {
        res = min(res, i);
    }

    return res;
}

/*
ll step(ll a, ll n) {
    if (n == 1)
        return a;

    if (n % 2)
        return (step(a, n - 1) % MOD * a) % MOD;

    ll prev = step(a, n / 2) % MOD;
    return (prev * prev) % MOD;
}
*/

/*
bool Kuhn(ll &v, vvll &g, vb &visited, vll &ans) {
    if (visited[v]) {
        return false;
    }

    visited[v] = true;

    for(auto &i : g[v]) {
        if (ans[i] == -1 || Kuhn(ans[i], g, visited, ans)) {
            ans[i] = v;
            return true;
        }
    }

    return false;
}
*/

/*
bool binSearch(string &s, ll &len, ll k) {
    ll n = s.size();
    for(ll i = 0; (i < n) && k; ++i) {
        ll ptr = 0;
        bool check = true;
        while(true) {
            if (ptr == len) {
                break;
            }

            if ((s[i + ptr] != s[ptr]) || (i + ptr >= n)) {
                check = false;
                break;
            }

            ++ptr;
        }

        if (check) {
            i += ptr - 1;
            --k;
        }
    }

    return !k;
}
*/

/*
vll parent;
vll high;

ll findParent(ll i) {
    if (parent[i] == i) {
        return i;
    }

    parent[i] = findParent(parent[i]);
    return parent[i];
}

void unite(ll i, ll j) {
    ll p1 = findParent(i);
    ll p2 = findParent(j);

    if (p1 == p2) {
        return;
    }

    if (high[p1] < high[p2])
        swap(p1, p2);

    parent[p2] = p1;
    high[p1] = max(high[p1], high[p2] + 1);
}

vvll check;
void dfs(ll cur, ll prev, ll dist, vec<vec<pll>> &m, ll start) {
    for(auto &i : m[cur]) {
        if (i.first == cur || i.first == prev) {
            continue;
        }

        check[start][i.first] = dist + i.second;

        //cout << start << ' ' << cur << ' ' << i << ' ' << dist << '\n';

        dfs(i.first, cur, dist + i.second, m, start);
    }
}
*/


set<ll> ez;
void resheto(ll n) {
    ez.clear();

    vec<bool> numbs(n, true);
    for (ll i = 2; i <= n; i++)
        if (numbs[i]) {
            ez.insert(i);
            for (ll j = i; j < n; j += i)
                numbs[j] = false;
        }
}

/*
ll binDegree(ll n, ll degree) {
    if (!degree) {
        re 1;
    }

    n %= MOD;

    if (degree == 1) {
        re n % MOD;
    }

    if (degree % 2) {
        re (n * binDegree(n, degree - 1)) % MOD;
    }

    ll res = (binDegree(n, degree / 2)) % MOD;
    return (res * res) % MOD;
}

bool isEz(ll n) {
    for (ll i = 2; i * i <= n; ++i) {
        if (n % i == 0) {
            re false;
        }
    }

    re true;
}
*/

/*
string toBin(ll n) {
    string result = "";
    ll step = 1;

    while (step <= n) {
        if (step & n)
            result.push_back('1');
        else
            result.push_back('0');
        step <<= 1;
    }

    //reverse(all(result));
    return result;
}
*/

/* class SparseTable {
public:
    vvpll table;
    SparseTable(vll &v) {
        ll n = v.size();
        table = vvpll(__lg(n) + 1, vpll(n));

        for (ll i = 0; i < n; ++i) {
            table[0][i] = {v[i], i};
        }

        for (ll i = 1; i <= __lg(n); ++i)
            for (ll j = 0; j < n - (1 << i) + 1; ++j) {
                pll f = table[i - 1][j], s = table[i - 1][j + (1 << (i - 1))];
                table[i][j] = f < s ? s : f;
            }
    }

    pll getMax(ll l, ll r) {
        ll lg = __lg(r - l + 1);
        pll f = table[lg][l], s = table[lg][r - (1 << lg) + 1];
        return f < s ? s : f;
    }
};
*/

class SegTree {
public:
    struct Node {
        ll val = 0;
        ll filledPoints = 0;

        Node *l = nullptr, *r = nullptr;
    };

    Node* head;
    ll size;

    SegTree(vll &v) {
        head = new Node();
        size = v.size();

        buildTree(head, 0, size, v);
    }

    SegTree(ll size){
        head = new Node();
        this->size = size;
        vll v(size, 0);

        buildTree(head, 0, size, v);
    }

    void buildTree(Node* node, ll curL, ll curR, vll &v) {
        if (curR - curL == 1) {
            node->val = 0;
            node->filledPoints = 0;
            re;
        }

        ll mid = (curL + curR) / 2;

        node->l = new Node();
        node->r = new Node();

        buildTree(node->l, curL, mid, v);
        buildTree(node->r, mid, curR, v);

        updateAfter(node, curL, curR);
    }

    static void updateBefore(Node* node, ll ql, ll qr) {
    }

    static void updateAfter(Node* node, ll ql, ll qr) {
        Node *l = node->l, *r = node->r;

        node->filledPoints = l->filledPoints + r->filledPoints;
    }

    /*ll getMax(ll ql, ll qr) {
        re getMax(head, 0, size, ql, qr);
    }

    ll getMax(Node* node, ll curL, ll curR, ll &ql, ll &qr) {
    }*/

    ll getSum(ll ql, ll qr) {
        re getSum(head, 0, size, ql, qr);
    }

    ll getSum(Node *node, ll curL, ll curR, ll ql, ll qr) {
        if (node == nullptr) {
            re 0;
        }

        if (curL >= qr || curR <= ql) {
            re 0;
        }

        if (ql <= curL && curR <= qr) {
            re node->filledPoints;
        }

        ll mid = (curL + curR) / 2;

        re getSum(node->l, curL, mid, ql, qr) + getSum(node->r, mid, curR, ql, qr);
    }

    void updateVal(ll ind, ll delta) {
        updateVal(head, 0, size, ind, delta);
    }

    void updateVal(Node *node, ll curL, ll curR, ll &ind, ll &delta) {
        if (curR - curL == 1) {
            node->val += delta;
            node->filledPoints = node->val != 0;
            re;
        }

        ll mid = (curR + curL) / 2;
        if (ind < mid) {
            updateVal(node->l, curL, mid, ind, delta);
        } else {
            updateVal(node->r, mid, curR, ind, delta);
        }

        updateAfter(node, curL, curR);
    }

    /*void setToSeg(ll ql, ll qr, ll val) {
        setToSeg(head, l, r, ql, qr, val);
    }

    void setToSeg(Node* node, ll curL, ll curR, ll &ql, ll &qr, ll &val) {
        if (node == nullptr || curL >= qr || curR <= ql) {
            re;
        }

        if (ql <= curL && curR <= qr) {
            ll h1 = hashForCount1[curR - 1];
            if (curL) {
                h1 -= hashForCount1[curL - 1];
            }

            ll h2 = hashForCount2[curR - 1];
            if (curL) {
                h2 -= hashForCount2[curL - 1];
            }

            node->hash1 = (h1 * val) % MOD1;
            node->hash2 = (h2 * val) % MOD2;
            node->needPush = val;
            re;
        }

        updateBefore(node, curL, curR);

        ll mid = (curL + curR) / 2;
        setToSeg(node->l, curL, mid, ql, qr, val);
        setToSeg(node->r, mid, curR, ql, qr, val);

        updateAfter(node);
    }*/

    void showMe() {
        showMe(head);
    }

    void showMe(Node* node) {
        if (node->l == nullptr && node->r == nullptr) {
            cout << node->val << ' ';
            re;
        }

        // updateBefore(node, curL, curR);

        showMe(node->l);
        showMe(node->r);
    }
};

double distBetweenPoints(pld p, pld q) {
    return pow(pow(p.first - q.first, 2) + pow(p.second - q.second, 2), 0.5);
}

ll myPow(ll numb, ll degree) {
    if (!degree) {
        return 1;
    }

    if (degree % 2) {
        return numb * myPow(numb, degree - 1);
    }
    ll res = myPow(numb, degree / 2);
    return res * res;
}

void solve() {
    ll n; cin >> n;
    ll r = 1;
    ll ans = 0;
    while (r <= n) {
        if (r & n) {
            ans++;
        }
        r <<= 1;
    }
    cout << ans << '\n';
}

signed main() {
    optimization_lvl_GOD;

    ll t = 1;
    // cin >> t;

    while (t--)
         solve();
}

/*
              #################
            ############__######
           ######__#####__#####
          ######__####__######
           ####__####__####
            ###__###__###
             ##__##__##
               #__#__#
            ############################
        #+++==     =========       #############
      #==         ==========        ################
     #==          ==========          #################
#++++++          ===========          ##################
    #==          ==========           ####################
     #==         ===========          ###################
      #++         ===========        ##################
       #+++==      ============    ################
         ################################
             ==========================
              ###            ###
                ####           ####
                   ####           ####
*/