#include <bits/stdc++.h>

#define int long long
#define ld long double

using namespace std;

const int MOD = 1e9 + 7;
const int MAX_SIZE = 1e6 + 10; 
vector<int> inv(MAX_SIZE); 
vector<int> W(MAX_SIZE); 

int add(int a, int b) {
    return (a + b) % MOD;
}

int sub(int a, int b) {
    return (a - b + MOD) % MOD;
}

int mul(int a, int b) {
    return (a * b) % MOD;
}

int power(int base, int exp) {
    int res = 1;
    base %= MOD;
    while (exp > 0) {
        if (exp % 2 == 1) res = mul(res, base);
        base = mul(base, base);
        exp /= 2;
    }
    return res;
}

int inverse(int n) {
    return power(n, MOD - 2);
}

int mdiv(int a, int b) {
    return mul(a, inverse(b));
}  

void precalc(int n) {
    inv[1] = 1;
    for (int i = 2; i <= n; ++i) {
        inv[i] = MOD - mul((MOD / i), inv[MOD % i]);
    }
}

void solve()  {
    int p, m;
    cin >> p >> m;

    int N = add(2 * p, m);
    int max_k = p + m;

    W[0] = 1;

    int E = 1;
    int Cnk = 1;

    for (int k = 1; k <= max_k; ++k) {
        int prev = k - 1;
        int prev2 = k - 2;

        int D = sub(add(2 * p, m), mul(3, prev));
        int term1 = mul(D, W[prev]);

        int term2 = 0;
        if (k > 1) {
            int D2 = mul(2, sub(add(p, m + 1), prev));
            term2 = mul(D2, W[prev2]);
        }

        W[k] = mul(add(term1, term2), inv[k]);

        Cnk = mul(Cnk, mul(sub(N, prev), inv[k]));

        E = add(E, mdiv(W[k], Cnk));
    }

    cout << E << "\n";
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    precalc(MAX_SIZE - 1);

    int tt = 1;
    cin >> tt;
    while (tt--) {
        solve();
    }
    return 0;
}
