#include <algorithm>
#include <cassert>
#include <cmath>
#include <cstdint>
#include <iostream>
#include <string>
#include <utility>
#include <vector>

// #pragma GCC optimize("Ofast")
// #pragma GCC target("avx,avx2,fma")

using namespace std;

using i64 = int64_t;
using u64 = uint64_t;
// using i128 = __int128_t;

struct p { double x, y; };
bool operator<(p a, p b) {
    return make_pair(a.y, a.x) < make_pair(b.y, b.x);
}

double dist(p a, p b) {
    double t = a.x - b.x;
    double s = a.y - b.y;
    return sqrt(t * t + s * s);
}

const double kPi = acos(-1.0);

struct vertex {
    char letter;
    vector<int> to;
};

auto build_piano() -> vector<vertex> {
    vector<vertex> g(52);
    for (int i = 0; i < 52; ++i) {
        char a = 'A' + i % ('G' - 'A' + 1);
        g[i].letter = a;
        for (int j = max(0, i - 3); j <= min(51, i + 3); ++j) {
            g[i].to.push_back(j);
        }
    }
    return g;
}

const auto piano = build_piano();

void solve() {
    // for (size_t i = 0; i < piano.size(); ++i) {
    //     cout << i << ' ' << piano[i].letter << ' ' << "[";
    //     for (auto u : piano[i].to) cout << u << ' ';
    //     cout << "]\n";
    // }
    string s;
    cin >> s;

    auto check = [](int v, const string& s) -> bool {
        for (auto it = s.begin(); it != s.end(); ++it) {
            auto to = find_if(
                    piano[v].to.begin(),
                    piano[v].to.end(),
                    [it](int u) -> bool {
                        return *it == piano[u].letter;
                    }
            );
            if (to == piano[v].to.end()) return false;
            v = *to;
        }
        return true;
    };

    for (size_t v = 0; v < piano.size(); ++v) {
        if (piano[v].letter != s[0]) continue;
        bool ok = check(v, s);
        if (ok) {
            cout << "YES\n";
            return;
        }
    }
    cout << "NO\n";
}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    cin >> t;
    while (t --> 0) {
        solve();
    }

    return 0;
}
