#include <algorithm>
#include <cassert>
#include <cmath>
#include <cstdint>
#include <deque>
#include <iostream>
#include <string>
#include <sstream>
#include <utility>
#include <vector>

// #pragma GCC optimize("Ofast")
// #pragma GCC target("avx,avx2,fma")

using namespace std;

using i64 = int64_t;
using u64 = uint64_t;
// using i128 = __int128_t;

struct hexagon {
    int n;
    int read_lines = 0;
    hexagon* inner = nullptr;
    deque<int8_t> a;
    deque<int8_t>::iterator it;

    hexagon(int n) : n(n) {
        if (n == 1) return;
        inner = new hexagon(n - 1);
    }

    using iter = vector<int8_t>::iterator;
    void read_line(iter it, iter end) {
        read_lines++;
        if (read_lines == 1) {
            while (it != end) {
                a.push_back(*it);
                ++it;
            }
            this->it = a.begin();
            assert((int)a.size() == n);
            return;
        }
        if (read_lines == 2 * n - 1) {
            while (it != end) {
                a.push_front(*it);
                ++it;
            }
            return;
        }
        a.push_front(*it);
        a.push_back(*(end - 1));
        if (inner) inner->read_line(it + 1, end - 1);
    }

};

vector<vector<int8_t>> convert_hex(hexagon& h) {
    vector<vector<int8_t>> a;
    hexagon* hex = &h;
    while (hex) {
        while (hex->a.begin() != hex->it) {
            hex->a.push_back(*hex->a.begin());
            hex->a.pop_front();
        }
        a.emplace_back(hex->a.begin(), hex->a.end());
        hex = hex->inner;
    }
    reverse(a.begin(), a.end());
    return a;
}

vector<int> ptrR;
vector<int> ptrL;
vector<vector<int>> out;
void print_ans(int n, const vector<vector<int8_t>>::iterator h, int state, bool debug) {
    auto ait = ptrR[n - 1];
    auto bit = ptrL[n - 1];
    if (debug)
        cout << "\nprint_ans " << n << ' ' << state << ' '
             << "AIT = " << ait << ' '
             << "BIT = " << bit << ' '
             << '\n';
    if (n == 1) {
        if (state == 0)
            out.back().push_back((*h)[0]);
        if (debug)
            cout << "\nEND print_ans " << n << ' ' << state << '\n';
        return;
    }
    if (state == 0) {
        auto ait = ptrR[n - 1];
        for (int i = 0; i < n; ++i) {
            out.back().push_back((*h)[ait]);
            // cout << (int)(*h)[ait] << ' ';
            ait = (ait + 1) % h->size();
        }
        ptrR[n - 1] = ait;
        if (debug)
            cout << "\nEND print_ans " << n << ' ' << state << '\n';
        return;
    }

    if (state == 2 * n - 2) {
        auto bit = ptrL[n - 1];
        for (int i = 0; i < n; ++i) {
            out.back().push_back((*h)[bit]);
            // cout << (int)(*h)[bit] << ' ';
            bit = (bit - 1 + h->size()) % h->size();
        }
        ptrL[n - 1] = bit;
        if (debug)
            cout << "\nEND print_ans " << n << ' ' << state << '\n';
        return;
    }

    for (int i = state; i < 2 * n - 1; ++i) {
        // cout << (int)(*h)[bit] << ' ';
        out.back().push_back((*h)[bit]);
        bit = (bit - 1 + h->size()) % h->size();
        ptrL[n - 1] = bit;

        print_ans(n - 1, h - 1, i - 1, debug);

        // cout << (int)(*h)[ait] << ' ';
        out.back().push_back((*h)[ait]);
        ait = (ait + 1) % h->size();
        ptrR[n - 1] = ait;

        if (debug)
            cout << "\nEND print_ans " << n << ' ' << state << '\n';
        return;
    }

}

void solve() {
    string s;
    getline(cin, s);
    int n;
    stringstream{s} >> n;
    hexagon hex(n);
    while(getline(cin, s)) {
        if (s[0] == 'L' || s[0] == 'T' || s[0] == 'R') break;
        stringstream ss{s};
        int x;
        vector<int8_t> a;
        while (ss >> x) {
            a.push_back(x);
        }
        hex.read_line(a.begin(), a.end());
    }


    // hexagon* wwww = &hex;
    // while (wwww) {
    //     for (int z : wwww->a) cout << z << ' ';
    //     cout << '\n';
    //     wwww = wwww->inner;
    // }
    auto x = convert_hex(hex);
    // for (auto& y : x) { for (int z : y) cout << z << ' '; cout << '\n'; }
    int ptr = 0;
    int sign = 1;
    for (char c : s) {
        if (c == 'T') {
            sign *= -1;
        }
        else {
            int to = (c == 'L' ? 1 : -1) * sign;
            ptr += to;
        }
    }
    ptrR.resize(n);
    ptrL.resize(n);
    for (int i = n - 1; i >= 0; --i) {
        auto ait = (ptr * (i + 1 - 1)) % (int)x[i].size();
        auto bit = (ait - 1 + (int)x[i].size()) % (int)x[i].size();
        ptrR[i] = ait;
        ptrL[i] = bit;
    }
    // cout << '\n' << ptr << '\n'; cout.flush();
    for (int i = 0; i < 2 * n - 1; ++i) {
        out.push_back({});
        print_ans(n, x.end() - 1, i, !true);
        // cout << "\n";
    }

    for (auto& v : out) {
        if (sign == -1)
            reverse(v.begin(), v.end());
        for (int x : v) cout << x << ' ';
        cout << '\n';
    }

}

signed main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    int t = 1;
    // cin >> t;
    while (t --> 0) {
        solve();
    }

    return 0;
}
