import sys
from functools import cache
from math import gcd
from random import randint
from collections import defaultdict, Counter

input = lambda: sys.stdin.readline().rstrip()

MOD = 10 ** 9 + 7


@cache
def coll(x):
    if x == 1:
        return 1
    if x % 2:
        return coll(3 * x + 1) + len(str(x))
    return coll(x // 2) + len(str(x))


sys.setrecursionlimit(10**5)
for _ in range(int(input())):
    k, = map(int, input().split())
    if k == 0:
        quit()
    while k > 1:
        if k % 2 == 0:
            print("collatz", flush=1)
        else:
            tmp = []
            for i in range(250):
                tmp.append(coll(randint(3 * k + 1, 6 * k)))
            if coll(k) > sum(tmp) / len(tmp):
                print("RANDOM", flush=1)
            else:
                print("collatz", flush=1)
        k, = map(int, input().split())
        if k == 0:
            quit()
