#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);

    const uint32_t MOD = 999983;
    const uint32_t A = 618023;
    const uint32_t MAX = MOD - 1;
    const int W = (MOD + 63) >> 6;

    int n;
    uint32_t s;
    cin >> n >> s;

    vector<uint64_t> B(W, 0), R(W, 0);
    
    auto set_bit = [&](uint32_t idx) {
        B[idx >> 6] |= 1ULL << (idx & 63);
        uint32_t ridx = MAX - idx;
        R[ridx >> 6] |= 1ULL << (ridx & 63);
    };
    
    auto test_bit = [&](uint32_t idx) {
        return B[idx >> 6] >> (idx & 63) & 1;
    };

    int added = 0;

    for (int step = 0; step < n; step++) {
        s = (uint64_t(s) * A + 1) % MOD;
        uint32_t Lbits = (s >> 1) + 1;
        uint32_t shift = MAX - s;

        int off = shift & 63;
        int base = shift >> 6;

        bool parity_bit = 0;
        int full = Lbits >> 6;
        int rem = Lbits & 63;

        for (int i = 0; i < full; i++) {
            uint64_t bw = B[i];
            uint64_t rw0 = base + i < W ? R[base + i] : 0;
            uint64_t rw1 = base + i + 1 < W ? R[base + i + 1] : 0;
            uint64_t rw = off ? (rw0 >> off) | (rw1 << (64 - off)) : rw0;
            parity_bit ^= __builtin_popcountll(bw & rw) & 1;
        }

        if (rem) {
            uint64_t mask = (1ULL << rem) - 1;
            uint64_t bw = B[full] & mask;
            uint64_t rw0 = base + full < W ? R[base + full] : 0;
            uint64_t rw1 = base + full + 1 < W ? R[base + full + 1] : 0;
            uint64_t rw = off ? (rw0 >> off) | (rw1 << (64 - off)) : rw0;
            parity_bit ^= __builtin_popcountll(bw & (rw & mask)) & 1;
        }

        if (!parity_bit && !test_bit(s)) {
            set_bit(s);
            added++;
        }
    }

    cout << added << '\n';
    return 0;
}