#include <bits/stdc++.h>
using namespace std;

const int MOD = 999983;

class Fenwick {
private:
    vector<int> tree;
    int size;
public:
    Fenwick(int n) : tree(n + 2, 0), size(n + 1) {}
    
    void update(int idx, int delta) {
        idx++;
        while (idx <= size) {
            tree[idx] ^= delta;
            idx += idx & -idx;
        }
    }
    
    int query(int idx) {
        idx++;
        int res = 0;
        while (idx > 0) {
            res ^= tree[idx];
            idx -= idx & -idx;
        }
        return res;
    }
};

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);
    
    int n;
    long long s;
    cin >> n >> s;
    
    Fenwick fenw(MOD);
    bitset<MOD> inSet;
    int count = 0;

    vector<int> elements;
    elements.reserve(n);
    
    for (int i = 0; i < n; ++i) {
        s = (s * 618023 + 1) % MOD;
        
        int pairs = 0;
        for (int x : elements) {
            int y = s - x;
            if (y < 0 || y >= MOD) continue;
            if (y < x) continue;
            
            if (inSet[y]) {
                pairs ^= 1;
            }
        }
        
        if (pairs == 0) {
            if (!inSet[s]) {
                inSet[s] = true;
                elements.push_back(s);
                count++;
            }
        }
    }
    
    cout << count << endl;
    return 0;
}