#include <iostream>
#include <vector>
#include <unordered_map>
using namespace std;

int main() {
    int run_type;
    cin >> run_type;
    int n;
    cin >> n;
    vector<int> cards(n);
    
    for (int i = 0; i < n; i++) {
        cin >> cards[i];
    }
    
    if (run_type == 0) {
        // Первый запуск - ищем уникальную карту
        unordered_map<int, int> count;
        for (int card : cards) {
            count[card]++;
        }
        
        for (int i = 0; i < n; i++) {
            if (count[cards[i]] == 1) {
                cout << i + 1 << endl;
                return 0;
            }
        }
        cout << 1 << endl; // Если все карты одинаковые
    } else {
        // Второй запуск - угадываем свою карту
        unordered_map<int, int> count;
        for (int card : cards) {
            count[card]++;
        }
        
        // Ищем карту, которой нет среди видимых, или берем первую
        for (int i = 1; i <= n; i++) {
            if (count[i] == 0) {
                cout << i << endl;
                return 0;
            }
        }
        cout << cards[0] << endl;
    }
    
    return 0;
}