import sys


def main():
    data = sys.stdin.read().split()
    n = int(data[0])
    lengths = list(map(int, data[1:1 + n]))

    total = sum(lengths)
    min_area = float('inf')
    max_area = 0

    for mask in range(1, (1 << n) - 1):
        s = 0
        for i in range(n):
            if mask & (1 << i):
                s += lengths[i]
        area = s * (total - s)
        if area < min_area:
            min_area = area
        if area > max_area:
            max_area = area

    print(min_area, max_area)


if __name__ == "__main__":
    main()