#include <array>
#include <tuple>
#include <iostream>

using namespace std;

using t1 = std::array<int, 3>;
using t2 = std::array<int, 4>;
using t3 = std::array<int, 5>;
using Gex = tuple<t1, t2, t3, t2, t1>;

template <typename T> void _t(T &r) {
    for (int i = 0; i < r.size() / 2; i++) {
        swap(r[i], r[r.size() - 1 - i]);
    }
}

void t(Gex &g) {
    _t(get<0>(g));
    _t(get<1>(g));
    _t(get<2>(g));
    _t(get<3>(g));
    _t(get<4>(g));
}

template <typename T> void _print(const T &r) {
    for (int i : r) {
        cout << i << " ";
    }
    cout << "\n";
}

void print(const Gex &g) {
    _print(get<0>(g));
    _print(get<1>(g));
    _print(get<2>(g));
    _print(get<3>(g));
    _print(get<4>(g));
}

auto &g1(Gex &g) { return get<0>(g); }

auto &g2(Gex &g) { return get<1>(g); }

auto &g3(Gex &g) { return get<2>(g); }

auto &g4(Gex &g) { return get<3>(g); }

auto &g5(Gex &g) { return get<4>(g); }

Gex lt(Gex &g) {
    Gex n;
    g1(n)[0] = g1(g)[2];
    g1(n)[1] = g2(g)[3];
    g1(n)[2] = g3(g)[4];

    g2(n)[0] = g1(g)[1];
    g2(n)[1] = g2(g)[2];
    g2(n)[2] = g3(g)[3];
    g2(n)[3] = g4(g)[3];

    g3(n)[0] = g1(g)[0];
    g3(n)[1] = g2(g)[1];
    g3(n)[2] = g3(g)[2];
    g3(n)[3] = g4(g)[2];
    g3(n)[4] = g5(g)[2];

    g4(n)[0] = g2(g)[0];
    g4(n)[1] = g3(g)[1];
    g4(n)[2] = g4(g)[1];
    g4(n)[3] = g5(g)[1];

    g5(n)[0] = g3(g)[0];
    g5(n)[1] = g4(g)[0];
    g5(n)[2] = g5(g)[0];
    return n;
}

Gex rt(Gex &g) {
    Gex n = g;
    for (int i = 0; i < 5; i++) {
        n = lt(n);
    }
    return n;
}

template <typename T> T _read() {
    T r;
    for (int i = 0; i < r.size(); i++) {
        cin >> r[i];
    }
    return r;
}

Gex read() {
    Gex n = {
            _read<t1>(), _read<t2>(), _read<t3>(), _read<t2>(), _read<t1>(),
    };
    return n;
}

int main() {
    int n;
    cin >> n;
    Gex g = read();
    while (n--) {
        char c;
        cin >> c;
        switch (c) {
            case 'L':
                g = lt(g);
                break;
            case 'R':
                g = rt(g);
                break;
            case 'T':
                t(g);
                break;
        }
    }
    print(g);
    return 0;
}