#include <algorithm>
#include <bitset>
#include <chrono>
#include <climits>
#include <cmath>
#include <fstream>
#include <functional>
#include <iostream>
#include <list>
#include <map>
#include <numeric>
#include <queue>
#include <set>
#include <stack>
#include <string>
#include <unordered_map>
#include <unordered_set>

using namespace std;

template<class T>
ostream &operator<<(ostream &out, const vector<T> &a) {
    for (auto &i: a) out << i << " ";
    return out;
}

template<class T>
T read() {
    T t;
    cin >> t;
    return t;
}

template<class T>
void operator>>(istream &in, vector<T> &a) { for (auto &i: a) in >> i; }

template<class T>
void operator>>(istream &in, vector<vector<T>> &a) { for (auto &i: a) in >> i; }

#define ll long long
#define uint unsigned int
#define ld long double
#define M_PI 3.14159265358979323846
#define aint(x) x.begin(), x.end()
#define raint(x) x.rbegin(), x.rend()
#define X first
#define Y second
#define int ll

constexpr int MOD = 1000000007LL;

int mulmod(int a, int b) {
    return (int)((__int128)a * b % MOD);
}

int binpow(int a, int e) {
    int r = 1;
    while (e > 0) {
        if (e & 1) r = mulmod(r, a);
        a = mulmod(a, a);
        e >>= 1;
    }

    return r;
}

vector<int> fact, invfact;

int fact_get(int n) {
    return fact[n];
}

int invfact_get(int n) {
    return invfact[n];
}

int inv(int x) {
    return binpow(x, MOD - 2);
}

int solve_one(int p, int m) {
    int term1 = (2 * p + m + 1) % MOD;
    int pow2 = binpow(2, 2 * p + 1);
    int fp = fact_get(p);
    int fpp1 = fact_get(p + 1);
    int fden_inv = invfact_get(2 * p + 2);
    int ans = term1;
    ans = mulmod(ans, pow2);
    ans = mulmod(ans, fp);
    ans = mulmod(ans, fpp1);
    ans = mulmod(ans, fden_inv);
    return ans % MOD;
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int T = read<int>();
    vector<int> P(T), Mv(T);
    int max_p = 0;
    for (int i = 0; i < T; i++) {
        cin >> P[i] >> Mv[i];
        max_p = max(max_p, P[i]);
    }

    int LIM = 2 * max_p + 2;
    fact.resize(LIM + 1);
    invfact.resize(LIM + 1);

    fact[0] = 1;
    for (int i = 1; i <= LIM; i++) {
        fact[i] = mulmod(fact[i - 1], i % MOD);
    }

    invfact[LIM] = inv(fact[LIM]);
    for (int i = LIM; i > 0; i--) {
        invfact[i - 1] = mulmod(invfact[i], i % MOD);
    }

    for (int i = 0; i < T; i++) {
        cout << solve_one(P[i], Mv[i]) << '\n';
    }
}