#include <bits/stdc++.h>

using namespace std;

random_device dev;
mt19937 rng(dev());
uniform_int_distribution<int> uid(0, 1);

#define int long long
using ld = long double;
using ll = long long;

constexpr ll mod = 1e9 + 7;

#define forn(i, n) for (ll i = 0; i < (n); ++i)
#define all(a) begin(a), end(a)

struct pair_hash {
    template <class T1, class T2>
    std::size_t operator()(const std::pair<T1, T2> &p) const {
        auto h1 = std::hash<T1>{}(p.first);
        auto h2 = std::hash<T2>{}(p.second);
        return h1 ^ h2;
    }
};

using point = pair<int, int>;
ostream &operator<<(ostream &os, point p) {
    return os << p.first << " " << p.second;
}

void solve() {
    //
    string s;
    cin >> s;
    //

    int n = s.size();

#define FAIL()                                                                 \
do {                                                                         \
cout << "NO\n";                                                            \
return;                                                                    \
} while (false)

    auto find_offset = [&](char curr, char next) {
        const char octaves[] = "ABCDEFGABCDEFGABCDEFG";
        const int idx = 7 + (curr - 'A');

        for (int i = idx; i >= idx - 3; --i) {
            if (octaves[i] == next) {
                return i - idx;
            }
        }
        for (int i = idx; i <= idx + 3; ++i) {
            if (octaves[i] == next) {
                return i - idx;
            }
        }

        assert(false);
    };

    int glob_off = 0;
    int min_left = glob_off, max_right = glob_off;

    for (int i = 1; i < n; ++i) {
        auto off = find_offset(s[i - 1], s[i]);
        glob_off += off;
        min_left = min(min_left, glob_off);
        max_right = max(max_right, glob_off);
    }

    auto init_off = s.front() - 'A';
    for (int octave = 0; octave < 7; ++octave) {
        auto init = octave * 7 + init_off;
        if (init + min_left >= 0 and init + max_right < 52) {
            cout << "YES\n";
            return;
        }
    }

    if (init_off < 3) {
        auto init = 49 + init_off;
        if (init + min_left >= 0 and init + max_right < 52) {
            cout << "YES\n";
            return;
        }
    }

    FAIL();
}

signed main() {
    int t = 1;
    cin >> t;
    while (t--) {
        solve();
    }
}