#include <bits/stdc++.h>

using namespace std;

random_device dev;
mt19937 rng(dev());
uniform_int_distribution<int> uid(0, 1);

#define int long long
using ld = long double;
using ll = long long;

constexpr ll mod = 1e9 + 7;



int fast_multiply(int a, int b) {
    return (a * b) % mod;
}

int fast_power(int base, int exponent) {
    int result = 1;
    base = base % mod;
    while (exponent > 0) {
        if (exponent % 2 == 1) {
            result = fast_multiply(result, base);
        }
        exponent = exponent >> 1;
        base = fast_multiply(base, base);
    }
    return result;
}

int mod_inverse(int a) {
    return fast_power(a, mod-2);
}

vector<int> fac_0(1e6+1);
vector<int> fac_1(1e6+1);



void solve() {
    int p, m;
    cin >> p >> m;
    vector<int> probs(p);
    probs[0] = mod_inverse(2*p-1);

    int mat = fast_multiply(fac_0[p-1], mod_inverse(fac_1[p-1]));;

    int ans = mat + fast_multiply(mat, fast_multiply(m, mod_inverse(2*p+1)));
    ans %= mod;
    cout << ans << '\n';
}

signed main() {
    int t = 1;
    cin >> t;
    fac_0[0] = 2;
    fac_1[0] = 1;
    for (int i = 1; i <= 1e6; i++) {
        fac_0[i] = fast_multiply(fac_0[i-1], (i+1)*2);
        fac_1[i] = fast_multiply(fac_1[i-1], (i+1)*2 -1);
    }
    while (t--) {
        solve();
    }
}
