import sys

input = sys.stdin.readline

# 52 белые клавиши: A-G циклично
white_keys = "ABCDEFG" * 7 + "ABC"  # len == 52

# Для каждой буквы все позиции на клавиатуре
positions = {c: [] for c in "ABCDEFG"}
for i, c in enumerate(white_keys):
    positions[c].append(i)

t = int(input())
result = []

for _ in range(t):
    melody = input().strip()
    
    # Для первой ноты - все подходящие клавиши
    reach = [False] * 52
    for i in positions[melody[0]]:
        reach[i] = True

    for note in melody[1:]:
        new_reach = [False] * 52
        for i in positions[note]:  # только нужные буквы
            # можно ли за 1 шаг попасть из reach на клавишу i?
            for delta in range(-3, 4):  # сдвиг от -3 до +3
                j = i + delta
                if 0 <= j < 52 and reach[j]:
                    new_reach[i] = True
                    break
        reach = new_reach
        if not any(reach):
            result.append("No")
            break
    else:
        result.append("Yes")

print('\n'.join(result))