import sys

input = sys.stdin.readline

# 52 белые клавиши по номерам с буквами A-G (7 октав + 3 ноты)
white_keys = "ABCDEFG" * 7 + "ABC"

# map: буква — список позиций на клавиатуре
positions = {c: [] for c in "ABCDEFG"}
for i, c in enumerate(white_keys):
    positions[c].append(i)

t = int(input())
result = []

for _ in range(t):
    s = input().strip()
    # сохраняем только позиции для каждой итерации (как маску достижимости)
    reachable = set(positions[s[0]])  # стартуем с любой ноты первой буквы

    for ch in s[1:]:
        candidates = set()
        for idx in positions[ch]:
            # быстро проверяем: есть ли достижимая позиция в окрестности idx±3
            for d in range(-3, 4):
                if (idx + d) in reachable:
                    candidates.add(idx)
                    break
        reachable = candidates
        if not reachable:
            break

    result.append("Yes" if reachable else "No")

print('\n'.join(result))