import math

def convex_hull(points):
    points = sorted(points)
    
    def cross(o, a, b):
        return (a[0]-o[0])*(b[1]-o[1]) - (a[1]-o[1])*(b[0]-o[0])
    
    lower = []
    for p in points:
        while len(lower) >= 2 and cross(lower[-2], lower[-1], p) <= 0:
            lower.pop()
        lower.append(p)
    
    upper = []
    for p in reversed(points):
        while len(upper) >= 2 and cross(upper[-2], upper[-1], p) <= 0:
            upper.pop()
        upper.append(p)
    
    return lower[:-1] + upper[:-1]

def line_from_points(p1, p2):
    # Прямая через p1 и p2: ax + by + c = 0
    a = p2[1] - p1[1]
    b = p1[0] - p2[0]
    c = p2[0]*p1[1] - p1[0]*p2[1]
    # Приводим к целым коэффициентам
    g = math.gcd(math.gcd(a, b), c)
    if g != 0:
        a //= g
        b //= g
        c //= g
    # Нормализуем знак
    if a < 0 or (a == 0 and b < 0):
        a, b, c = -a, -b, -c
    return a, b, c

def point_line_distance(a, b, c, pt):
    return abs(a*pt[0] + b*pt[1] + c) / math.hypot(a, b)

# Чтение входных данных
n = int(input())
points = [tuple(map(int, input().split())) for _ in range(n)]

hull = convex_hull(points)
m = len(hull)

max_dist = -1
best_lines = None

# Для каждого ребра выпуклой оболочки
for i in range(m):
    p1 = hull[i]
    p2 = hull[(i+1) % m]
    
    # Находим самую дальнюю точку от этого ребра
    a, b, c = line_from_points(p1, p2)
    
    farthest_dist = -1
    farthest_pt = None
    for pt in hull:
        dist = point_line_distance(a, b, c, pt)
        if dist > farthest_dist:
            farthest_dist = dist
            farthest_pt = pt
    
    # Строим параллельную прямую через farthest_pt
    c2 = -a*farthest_pt[0] - b*farthest_pt[1]
    
    # Проверяем, что все точки между прямыми
    c1 = c
    ok = True
    for pt in points:
        val = -a*pt[0] - b*pt[1]
        if not (min(c1, c2) <= val <= max(c1, c2)):
            ok = False
            break
    
    if ok:
        dist = farthest_dist
        if dist > max_dist:
            max_dist = dist
            # Сохраняем прямые
            best_lines = [(a, b, c1), (a, b, c2)]

# Вывод
for line in best_lines:
    print(*line)