import sys

def rotate_60_cw(hex_data, n):
    # Поворот на 60° по часовой стрелке
    new_hex = []
    lengths = list(range(n, 2*n)) + list(range(2*n-2, n-1, -1))
    
    for i in range(2*n - 1):
        new_row = []
        # Правило зависит от индекса строки
        if i < n-1:
            # Верхняя часть
            for j in range(lengths[i]):
                # Из исходной таблицы
                src_row = n-1 - j
                src_col = i
                new_row.append(hex_data[src_row][src_col])
        elif i == n-1:
            # Средняя строка
            for j in range(2*n-1):
                src_row = 2*n-2 - j
                src_col = n-1
                new_row.append(hex_data[src_row][src_col])
        else:
            # Нижняя часть
            for j in range(lengths[i]):
                src_row = 2*n-2 - j
                src_col = 2*n-2 - i
                new_row.append(hex_data[src_row][src_col])
        new_hex.append(new_row)
    return new_hex

def reflect_vertical(hex_data, n):
    # Отражение относительно вертикальной оси
    new_hex = []
    for row in hex_data:
        new_hex.append(row[::-1])
    return new_hex

def apply_transformation(hex_data, n, rot, flip):
    # Применяем отражение, если нужно
    if flip:
        hex_data = reflect_vertical(hex_data, n)
    
    # Применяем поворот
    for _ in range(rot):
        hex_data = rotate_60_cw(hex_data, n)
    
    return hex_data

# Чтение входных данных
data = sys.stdin.read().splitlines()
n = int(data[0])

hex_data = []
idx = 1
for i in range(2*n - 1):
    parts = data[idx].split()
    hex_data.append([int(x) for x in parts])
    idx += 1

ops = data[idx].strip()

# Нормализация операций
rot = 0
flip = 0

for op in ops:
    if op == 'T':
        flip ^= 1
    elif op == 'R':
        if flip == 0:
            rot = (rot + 1) % 6
        else:
            rot = (rot - 1) % 6
    elif op == 'L':
        if flip == 0:
            rot = (rot - 1) % 6
        else:
            rot = (rot + 1) % 6

# Применяем преобразование
result = apply_transformation(hex_data, n, rot, flip)

# Вывод результата
for row in result:
    print(' '.join(map(str, row)))