#include <iostream>
#include <algorithm>
#include <vector>
#include <numbers>
#include <set>
#include <map>
#include <unordered_set>
#include <unordered_map>
#include <cmath>
#include <iomanip>

using namespace std;

using ll = long long;
using ld = long double;
using ull = unsigned long long;

const ll inf = 1e18;

struct Point {
    int x;
    int y;
};

std::istream& operator>>(std::istream& in, Point& p) {
    in >> p.x >> p.y;
    return in;
}

bool operator==(Point& lhs, Point& rhs) {
    return lhs.x == rhs.x && lhs.y == rhs.y;
}

using Vector = Point;

Vector operator-(Point& lhs, Point& rhs) {
    return {lhs.x - rhs.x, lhs.y - rhs.y};
}

int vec(Vector lhs, Vector rhs) {
    return lhs.x * rhs.y - lhs.y * rhs.x; 
}

ll scalar(Vector& lhs, Vector& rhs) {
    return lhs.x * rhs.x + lhs.y * rhs.y;
}

ld length(Vector& vec) {
    return sqrt(scalar(vec, vec));
}

void line(Point p, Vector v) {
    int a = v.x;
    int b = v.y;
    int c = -a * p.x - b * p.y;
    std::cout << a << " " << b << ' ' << c << '\n';
}

int orientation(Point p, Point q, Point r)
{
    int val = (q.y - p.y) * (r.x - q.x) -
              (q.x - p.x) * (r.y - q.y);

    if (val == 0) return 0;
    return (val > 0)? 1: 2;
}

signed main() {
    #ifdef ICPC
        freopen("in.txt", "r", stdin);
    #else
        std::ios_base::sync_with_stdio(false);
        std::cin.tie(0);
    #endif
    int n;
    std::cin >> n;
    std::vector<Point> points(n);
    for (auto& p : points) {
        std::cin >> p;
    }
    std::vector<Point> hull;
    int l = 0;
    for (int i = 1; i < n; i++)
        if (points[i].x < points[l].x)
            l = i;

    int p = l, q;
    do
    {
        hull.push_back(points[p]);

        q = (p+1)%n;
        for (int i = 0; i < n; i++)
        {
           if (orientation(points[p], points[i], points[q]) == 2)
               q = i;
        }
        p = q;

    } while (p != l);
    std::pair<Point, Point> chosen;
    ld max_dist = 0;
    for (auto& p : hull) {
        for (auto& q : hull) {
            if (p == q) {
                continue;
            }
            Vector pq{q.x - p.x, q.y - p.y};
            ld len = length(pq);
            if (len >= max_dist) {
                max_dist = len;
                chosen = {p, q};
            }
        }
    }
    Vector per{chosen.second.x - chosen.first.x, chosen.second.y - chosen.first.y};
    line(chosen.first, per);
    line(chosen.second, per);
}