#include <iostream>
#include <unordered_set>

using namespace std;

static long long count_pairs(const unordered_set<int>& V, int s) {
    long long cnt = 0;
    for (int a : V) {
        int b = s - a;
        if (a < b && V.find(b) != V.end()) {
            ++cnt;
        }
    }
    if (s % 2 == 0 && V.find(s / 2) != V.end()) {
        ++cnt;
    }
    return cnt;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, s;
    if (!(cin >> n >> s)) return 0;

    unordered_set<int> V;
    V.reserve(n * 2);

    for (int i = 0; i < n; ++i) {
        s = static_cast<int>(( (1LL * s) * 618023 + 1 ) % 999983);
        if (count_pairs(V, s) % 2 == 0) {
            V.insert(s);
        }
    }
    cout << V.size() << '\n';
    return 0;
}
