﻿#include <iostream>
#include <string>
#include <algorithm>
using namespace std;

string to_binary(long long n) {
    string s;
    while (n > 0) {
        s.push_back((n % 2) + '0');
        n /= 2;
    }
    reverse(s.begin(), s.end());
    return s.empty() ? "0" : s;
}

long long reverse(const string& s) {
    string t = s;
    reverse(t.begin(), t.end());
    int pos = 0;
    while (pos < (int)t.size() && t[pos] == '0') 
        pos++;
    if (pos == (int)t.size()) 
        return 0; 
    t = t.substr(pos);
    long long res = 0;
    for (char c : t)
        res = res * 2 + (c - '0');
    return res;
}

int main() {
    ios::sync_with_stdio(false);

    long long n;
    cin >> n;

    int steps = 0;
    while (n > 0) {
        string bin = to_binary(n);
        long long rev = reverse(bin);
        n = rev - 1;
        steps++;
    }

    cout << steps;
    return 0;
}