from math import gcd

def distance_sq(p1, p2):
    return (p1[0] - p2[0]) ** 2 + (p1[1] - p2[1]) ** 2

def farthest_points(points):
    n = len(points)
    max_dist_sq = -1
    p1, p2 = points[0], points[1]
    for i in range(n):
        for j in range(i + 1, n):
            dist_sq = distance_sq(points[i], points[j])
            if dist_sq > max_dist_sq:
                max_dist_sq = dist_sq
                p1, p2 = points[i], points[j]
    return p1, p2

def perpendicular_line_through_point(a, b, c, point):
    a_perp = b
    b_perp = -a
    c_perp = -a_perp * point[0] - b_perp * point[1]
    g = gcd(gcd(a_perp, b_perp), c_perp)
    if g != 0:
        a_perp //= g
        b_perp //= g
        c_perp //= g
    if a_perp < 0 or (a_perp == 0 and b_perp < 0):
        a_perp, b_perp, c_perp = -a_perp, -b_perp, -c_perp
    return a_perp, b_perp, c_perp

n = int(input())
points = [tuple(map(int, input().split())) for _ in range(n)]
A, B = farthest_points(points)
a_line = A[1] - B[1]
b_line = B[0] - A[0]
c_line = A[0] * B[1] - B[0] * A[1]

g = gcd(gcd(a_line, b_line), c_line)
if g != 0:
    a_line //= g
    b_line //= g
    c_line //= g

if a_line < 0 or (a_line == 0 and b_line < 0):
    a_line, b_line, c_line = -a_line, -b_line, -c_line

line1 = perpendicular_line_through_point(a_line, b_line, c_line, A)
line2 = perpendicular_line_through_point(a_line, b_line, c_line, B)

print(*line1)
print(*line2)
