#pragma GCC optimize("O3")
#pragma GCC optimize("unroll-loops")
#include <iostream>
#include <string>
#include <climits>
#include <vector>
#include <cmath>
#include <algorithm>


using namespace std;

const int MOD = 1'000'000'007;
const int MAXN = 2'000'010;

vector<long long> fact(MAXN);
vector<long long> ifact(MAXN);

long long mod_pow(long long a, long long b) {
    long long res = 1;
    a %= MOD;
    while (b) {
        if (b & 1) res = res * a % MOD;
        a = a * a % MOD;
        b >>= 1;
    }
    return res;
}

void factorials() {

    fact[0] = 1;
    for (int i = 1; i < MAXN; i++)
        fact[i] = fact[i - 1] * i % MOD;

    ifact[MAXN - 1] = mod_pow(fact[MAXN - 1], MOD - 2);
    for (int i = MAXN - 2; i >= 0; i--)
        ifact[i] = ifact[i + 1] * (i + 1) % MOD;
}


long long nCr(long long n, long long r) {
    if (r < 0 || r > n) return 0;
    return fact[n] * ifact[r] % MOD * ifact[n - r] % MOD;
}

long long solve(long long p, long long m){
    int n = 2 * p + m;
    long long E = 0;
    for (long long t = 0; t <= p + m; t++) {
        long long A = 0;
        int u_max = min(p, t);
        for (int i = 0; i <= u_max; i++) {
            long long temp = nCr(p, i) * mod_pow(2, i) % MOD * nCr(m, t - i) % MOD;
            A = (A + temp) % MOD;
        }
        long long denom = nCr(n, t);
        E = (E + A * mod_pow(denom, MOD - 2) % MOD) % MOD;
    }
    return E;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int t;
    factorials();
    cin >> t;
    while (t--) {
        int p, m;
        cin >> p >> m;
        cout << solve(p, m) << endl;
    }
    return 0;
}
