#include <bits/stdc++.h>
using namespace std;

static inline bool is_even(const string& s){
    return !s.empty() && ((s.back()-'0')%2==0);
}

static inline int mod_pow2(const string& s, int k){
    int m = 1<<k, r = 0;
    for(char c: s){
        if(c>='0' && c<='9') r = (r*10 + (c-'0')) % m;
    }
    return r;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        while(true){
            if(x == "0") return 0;
            if(x == "1") break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                continue;
            }

            const int K = 4;
            const int MAX_BLUE = 12;
            const size_t MAX_GROW = x.size()+2;

            bool good = false;
            for(int i=0;i<MAX_BLUE;i++){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                if(x == "1"){ good = true; break; }
                if(mod_pow2(x, K) == 0){ good = true; break; }
                if(x.size() > MAX_GROW) break;
            }
            if(x == "1") break;
            if(x == "0") return 0;

            if(!good && !is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
            }
        }
    }
    return 0;
}
