#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    long long spent = 0;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                continue;
            }

            int L = digits(x);
            double avg_so_far = (round == 0 ? 0.0 : (double)spent / round);

            int k = 0, max_blue = 0;
            if(L <= 6){ k = 11; max_blue = 4; }
            else if(L <= 8){ k = 9; max_blue = 3; }
            else if(L <= 10){ k = 7; max_blue = 2; }
            else if(L <= 12){ k = 6; max_blue = 1; }
            else { k = 0; max_blue = 0; }

            if(avg_so_far < 580.0){
                if(max_blue > 0) max_blue -= 1;
            }else if(avg_so_far > 610.0){
                if(L <= 10) max_blue += 1;
            }

            bool succeeded = false;
            int startL = L;

            for(int tries = 0; tries < max_blue; ++tries){
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
                if(is_one(x)){ succeeded = true; break; }
                unsigned v = v2_cap(x, 12);
                if(v >= (unsigned)k){
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                        spent += digits(x);
                    }
                    succeeded = true;
                    break;
                }
                if(digits(x) - startL > 1) break;
            }

            if(succeeded) continue;

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;
            spent += digits(x);

            while(!is_one(x) && is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                spent += digits(x);
            }
        }
    }
    return 0;
}
