#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s=="1"; }
static inline bool is_even(const string& s){ return ((s.back()-'0') & 1) == 0; }
static inline int digits(const string& s){ return (int)s.size(); }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    long long total_spent = 0;

    int global_blue_cap = 12;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        int blues_this_round = 0;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                total_spent += digits(x);
                continue;
            }


            int L = digits(x);
            int tries = 0, max_tries = 0, need_v2 = 0;

            if(L <= 4){ max_tries = 5; need_v2 = 11; }
            else if(L == 5){ max_tries = 3; need_v2 = 10; }
            else if(L == 6){ max_tries = 2; need_v2 = 9; }
            else { max_tries = 0; need_v2 = 0; }


            max_tries = min(max_tries, max(0, global_blue_cap));
            bool paid_off = false;
            int start_len = L;

            while(tries < max_tries && blues_this_round == 0){
                ++tries;
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                total_spent += digits(x);

                if(is_one(x)){ paid_off = true; break; }

                int curL = digits(x);

                if(curL - start_len >= 2) break;

                unsigned v = v2_cap(x, 12);
                if(v >= (unsigned)need_v2){
                    ++blues_this_round;
                    --global_blue_cap;
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                        total_spent += digits(x);
                    }
                    paid_off = true;
                    break;
                }
            }

            if(paid_off) continue;

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;
            total_spent += digits(x);

            while(!is_one(x) && is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                total_spent += digits(x);
            }
        }
    }
    return 0;
}
