#include <bits/stdc++.h>
using namespace std;

static inline bool is_one(const string& s){ return s == "1"; }
static inline bool is_even(const string& s){ return ((s.back() - '0') & 1) == 0; }

static unsigned v2_cap(const string& s, unsigned cap){
    unsigned M = 1u << cap, rem = 0;
    for(char c: s) rem = (rem * 10u + (unsigned)(c - '0')) % M;
    if(rem == 0) return cap;
    unsigned k = 0;
    while(k < cap && ((rem >> k) & 1u) == 0u) ++k;
    return k;
}

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int t;
    if(!(cin >> t)) return 0;

    const int MAX_BLUE_LEN = 4;
    const unsigned ACCEPT_V2 = 10;

    for(int round = 0; round < t; ++round){
        string x;
        if(!(cin >> x)) return 0;

        bool blue_used_this_round = false;

        while(true){
            if(is_one(x)) break;

            if(is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                continue;
            }

            bool can_try_blue = !blue_used_this_round && (int)x.size() <= MAX_BLUE_LEN;

            if(can_try_blue){
                string before = x;
                cout << "random\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
                blue_used_this_round = true;

                if(is_one(x)) continue;

                unsigned v = v2_cap(x, 12);
                if(v >= ACCEPT_V2){
                    while(!is_one(x) && is_even(x)){
                        cout << "collatz\n" << flush;
                        if(!(cin >> x)) return 0;
                        if(x == "0") return 0;
                    }
                    continue;
                }
            }

            cout << "collatz\n" << flush;
            if(!(cin >> x)) return 0;
            if(x == "0") return 0;

            while(!is_one(x) && is_even(x)){
                cout << "collatz\n" << flush;
                if(!(cin >> x)) return 0;
                if(x == "0") return 0;
            }
        }
    }
    return 0;
}
