#include <bits/stdc++.h>
using namespace std;

#define ll long long
#define all(x) (x).begin(), (x).end()

struct r {
    int x, y;
};

r operator+(r a, r b) { return {a.x + b.x, a.y + b.y}; }
r operator-(r a, r b) { return {a.x - b.x, a.y - b.y}; }
int operator*(r a, r b) { return a.x * b.x + a.y * b.y; }
int operator^(r a, r b) { return a.x * b.y - a.y * b.x; }
bool operator==(r a, r b) { return a.x == b.x && a.y == b.y; }
bool operator!=(r a, r b) { return !(a == b); }

vector<r> jarvis(vector<r>& points) {
    int n = points.size();
    if (n < 3) return points;

    int left = 0;
    for (int i = 1; i < n; ++i) {
        if (points[i].x < points[left].x ||
            (points[i].x == points[left].x && points[i].y < points[left].y))
            left = i;
    }

    vector<r> hull;
    int p = left;

    do {
        hull.push_back(points[p]);
        int q = (p + 1) % n;
        for (int i = 0; i < n; ++i) {
            int cross = (points[i] - points[p]) ^ (points[q] - points[p]);
            if (cross > 0 ||
                (cross == 0 && ((points[i] - points[p]) * (points[i] - points[p])) >
                               ((points[q] - points[p]) * (points[q] - points[p]))))
                q = i;
        }
        p = q;
    } while (p != left);

    return hull;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<r> a(n);
    for (int i = 0; i < n; i++) {
        cin >> a[i].x >> a[i].y;
    }
    vector <r> hull = jarvis(a);
    r normal = {0, 0};
    r p0 = hull[0], p1 = hull[0];
    for (r a : hull) {
        for (r b : hull) {
            r newnormal = a - b;
            if (hypot(newnormal.x, newnormal.y) > hypot(normal.x, normal.y)) {
                normal = newnormal;
                p0 = a;
                p1 = b;
            }
        }
    }
    cout << normal.x << ' ' << normal.y << ' ' << -(normal.x * p0.x + normal.y * p0.y) << '\n';
    cout << normal.x << ' ' << normal.y << ' ' << -(normal.x * p1.x + normal.y * p1.y) << '\n';

    return 0;
}