#include <iostream>
#include <vector>
#include <algorithm>
#include <set>
#include <cstdint>
using namespace std;

struct Point
{
    int x, y;
    Point(int x_val, int y_val) : x(x_val), y(y_val) {}
};

int64_t scalar(Point a, Point b, Point c) {
    return (b.x - a.x)*(c.x - a.x)+(b.y - a.y)* (c.y - a.y);
}
int64_t dist(Point a, Point b){
    return scalar(a, b, b);
}


std::pair<Point, Point> max_dist(std::vector<Point>& a) {
    int64_t mx_dist = 0;
    int64_t index_1, index_2;
    for (int i =0; i<a.size(); i++) {
        for (int j=i; j<a.size(); j++) {
            if (dist(a[i], a[j])>mx_dist) {
                mx_dist = dist(a[i], a[j]);
                index_1 = i;
                index_2 = j;
            }
        }
    }
    return make_pair(a[index_1], a[index_2]);
}

int main()
{
    int64_t n;
    cin>>n;
    vector<Point> a;
    int64_t x, y;
    for (int64_t i=0; i<n; i++) {
        cin>>x>>y;
        a.push_back(Point(x, y));
    }
    pair<Point, Point> ans = max_dist(a);
    int64_t x1, y1, x2, y2;
    x1 = ans.first.x;
    y1 = ans.first.y;
    x2 = ans.second.x;
    y2 = ans.second.y;
    
    int64_t coef_x = x1 - x2;
    int64_t coef_y = y1 - y2;
    int64_t c_first = -coef_x*x1-coef_y*y1;
    int64_t c_second = -coef_x*x2-coef_y*y2;
    cout << coef_x<<" "<<coef_y<<" "<<c_first<<endl;
    cout << coef_x<<" "<<coef_y<<" "<<c_second<<endl;
    return 0;
}