import sys

input = sys.stdin.readline

base = ['A', 'B', 'C', 'D', 'E', 'F', 'G']
keyboard = base * 7 + ['A', 'B', 'C'] 

W = len(keyboard)
full_mask = (1 << W) - 1

mask_by_note = {c: 0 for c in 'ABCDEFG'}
for i, c in enumerate(keyboard):
    mask_by_note[c] |= (1 << i)

t = int(input().strip())
answers = []

for _ in range(t):
    s = input().strip()

    cur = mask_by_note[s[0]]

    ok = True
    for ch in s[1:]:
        left3  = (cur << 3) & full_mask
        left2  = (cur << 2) & full_mask
        left1  = (cur << 1) & full_mask
        mid    = cur
        right1 = cur >> 1
        right2 = cur >> 2
        right3 = cur >> 3

        reachable = left3 | left2 | left1 | mid | right1 | right2 | right3

        cur = reachable & mask_by_note[ch]

        if cur == 0:
            ok = False
            break

    answers.append("YES" if ok else "NO")

sys.stdout.write("\n".join(answers))
