import sys

MOD = 10**9 + 7

data = sys.stdin.read().strip().split()
t = int(data[0])
vals = []
idx = 1
max_p = 0
for _ in range(t):
    p = int(data[idx]); m = int(data[idx+1])
    vals.append((p, m))
    idx += 2
    if p > max_p:
        max_p = p

limit = 2 * max_p

fact = [1] * (limit + 1)
for i in range(1, limit + 1):
    fact[i] = fact[i-1] * i % MOD

invfact = [1] * (limit + 1)
invfact[limit] = pow(fact[limit], MOD-2, MOD)
for i in range(limit, 0, -1):
    invfact[i-1] = invfact[i] * i % MOD

pow2 = [1] * (2*max_p + 1)
for i in range(1, 2*max_p + 1):
    pow2[i] = (pow2[i-1] * 2) % MOD

out_lines = []
for p, m in vals:
    two_p = 2 * p

    c = fact[two_p] * invfact[p] % MOD * invfact[p] % MOD
    num_a = pow2[two_p] % MOD
    inv_c = pow(c, MOD-2, MOD)
    base = num_a * inv_c % MOD

    top = (m + 2*p + 1) % MOD
    bot = (2*p + 1) % MOD
    inv_bot = pow(bot, MOD-2, MOD)

    ans = base * top % MOD
    ans = ans * inv_bot % MOD

    out_lines.append(str(ans))

sys.stdout.write("\n".join(out_lines))