#include <iostream>
using namespace std;

const long long MOD = 1000000007;

long long powerMod(long long base, long long exp, long long mod) {
    long long result = 1;
    base %= mod;
    while (exp > 0) {
        if (exp & 1) {
            result = (result * base) % mod;
        }
        base = (base * base) % mod;
        exp >>= 1;
    }
    return result;
}

long long modInverse(long long a, long long mod) {
    return powerMod(a, mod - 2, mod);
}

int main() {
    int t;
    cin >> t;

    while (t--) {
        long long p, m;
        cin >> p >> m;
        long long numerator = (4LL * p + 2LL * m + 2LL) % MOD;
        long long denominator = (2LL * p + 1LL) % MOD;
        long long invDenominator = modInverse(denominator, MOD);
        long long answer = (numerator * invDenominator) % MOD;

        cout << answer << endl;
    }

    return 0;
}
