#include <iostream>
#include <vector>
#include <cmath>
#include <algorithm>
#include <limits>

using namespace std;

struct Point {
    int x, y;
};

// Функция для вычисления расстояния между параллельными прямыми
double parallel_distance(int a, int b, int c1, int c2) {
    return abs(c1 - c2) / sqrt(a * a + b * b);
}

// Функция для нахождения НОД двух чисел
int gcd(int a, int b) {
    while (b) {
        int temp = b;
        b = a % b;
        a = temp;
    }
    return a;
}

// Нормализация коэффициентов прямой
void normalize_line(int &a, int &b, int &c) {
    if (a < 0 || (a == 0 && b < 0)) {
        a = -a;
        b = -b;
        c = -c;
    }

    int g = gcd(abs(a), gcd(abs(b), abs(c)));
    if (g > 1) {
        a /= g;
        b /= g;
        c /= g;
    }
}

int main() {
    int n;
    cin >> n;

    vector<Point> points(n);
    for (int i = 0; i < n; i++) {
        cin >> points[i].x >> points[i].y;
    }

    double max_dist = -1;
    int best_a = 0, best_b = 0, best_c1 = 0, best_c2 = 0;

    // Перебираем все пары точек для построения направляющих прямых
    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            // Прямая через points[i] и points[j]
            int a = points[j].y - points[i].y;
            int b = points[i].x - points[j].x;
            int c_base = -a * points[i].x - b * points[i].y;

            // Пропускаем вырожденный случай
            if (a == 0 && b == 0) continue;

            // Находим минимальное и максимальное значение a*x + b*y
            int min_val = a * points[0].x + b * points[0].y;
            int max_val = min_val;

            for (int k = 1; k < n; k++) {
                int val = a * points[k].x + b * points[k].y;
                min_val = min(min_val, val);
                max_val = max(max_val, val);
            }

            // Вычисляем расстояние между параллельными прямыми
            double dist = parallel_distance(a, b, -min_val, -max_val);

            if (dist > max_dist) {
                max_dist = dist;
                best_a = a;
                best_b = b;
                best_c1 = -max_val;  // Одна граница через точку с max_val
                best_c2 = -min_val;  // Другая граница через точку с min_val
            }
        }
    }

    // Нормализуем коэффициенты
    normalize_line(best_a, best_b, best_c1);
    normalize_line(best_a, best_b, best_c2);

    // Выводим результат
    cout << best_a << " " << best_b << " " << best_c1 << endl;
    cout << best_a << " " << best_b << " " << best_c2 << endl;

    return 0;
}
