#include <iostream>
#include <vector>
#include <climits>

using ull = unsigned long long;

using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<ull> a(n);
    ull total = 0;

    for (int i = 0; i < n; ++i) {
        cin >> a[i];
        total += a[i];
    }

    ull min_area = ULLONG_MAX;
    ull max_area = 0;

    int total_masks = 1 << n;

    for (int mask = 1; mask < total_masks - 1; ++mask) {
        ull s = 0;

        for (int i = 0; i < n; ++i) {
            if (mask & (1 << i)) {
                s += a[i];
            }
        }

        ull other = total - s;
        ull area = s * other;

        if (area < min_area) min_area = area;
        if (area > max_area) max_area = area;
    }

    cout << min_area << " " << max_area << "\n";
    return 0;
}
