#include <bits/stdc++.h>

typedef long long ll;
static const ll MOD = 1'000'000'007;

ll modpow(ll a, ll e) {
  ll r = 1 % MOD;
  while (e) {
    if (e & 1)
      r = (r * a) % MOD;
    a = (a * a) % MOD;
    e >>= 1;
  }
  return r;
}

int main() {
  std::ios::sync_with_stdio(false);
  std::cin.tie(nullptr);
  int t;
  if (!(std::cin >> t))
    return 0;
  std::vector<std::pair<int, int>> qs(t);
  int maxp = 0;
  for (int i = 0; i < t; ++i) {
    int p, m;
    std::cin >> p >> m;
    qs[i] = {p, m};
    maxp = std::max(maxp, p);
  }

  int LIM = 2 * maxp;
  std::vector<ll> fact(LIM + 1), invfact(LIM + 1);
  fact[0] = 1;
  for (int i = 1; i <= LIM; ++i)
    fact[i] = fact[i - 1] * i % MOD;
  invfact[LIM] = modpow(fact[LIM], MOD - 2);
  for (int i = LIM; i > 0; --i)
    invfact[i - 1] = invfact[i] * i % MOD;

  auto C = [&](int n, int k) -> ll {
    if (k < 0 || k > n)
      return 0;
    return fact[n] * invfact[k] % MOD * invfact[n - k] % MOD;
  };

  for (auto [p, m] : qs) {
    ll comb = C(2 * p, p); // C(2p, p)
    ll denom = ((2LL * p + 1) % MOD) * comb % MOD;
    ll numer = modpow(4, p) * ((m + 2LL * p + 1) % MOD) % MOD;
    ll ans = numer * modpow(denom, MOD - 2) % MOD;
    std::cout << ans << '\n';
  }
  return 0;
}
