#include <bits/stdc++.h>
// #pragma comment(linker, "/STACK:16777216")
// #pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,sse4,fma,bmi,bmi2,popcnt,lzcnt,abm,tune=native")

using namespace std;
using uint = unsigned int;
using ll = long long;
using ull = unsigned long long;
using dbl = double;
using ld = long double;
using vll = vector<ll>;
using pi = pair<int, int>;
using pll = pair<ll, ll>;
using pd = pair<dbl, dbl>;
using pld = pair<ld, ld>;

#define ft first
#define sc second
#define pb push_back
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

struct Pt {
    ll x, y;
    bool operator<(const Pt& other) const {
        if (x != other.x) return x < other.x;
        return y < other.y;
    }
};

static inline ll cross(const Pt& a, const Pt& b, const Pt& c) {
    return (b.x - a.x) * (c.y - a.y) - (b.y - a.y) * (c.x - a.x);
}

static inline ll dist2(const Pt& a, const Pt& b) {
    ll dx = a.x - b.x, dy = a.y - b.y;
    return dx*dx + dy*dy;
}

vector<Pt> func(vector<Pt> pts) {
    ll n = pts.size();
    sort(pts.begin(), pts.end());
    if (n <= 1) return pts;

    vector<Pt> lower, upper;
    for (const auto& p : pts) {
        while (lower.size() >= 2 && cross(lower[lower.size()-2], lower.back(), p) <= 0) {
            lower.pop_back();
        }
        lower.push_back(p);
    }
    for (ll i = n - 1; i >= 0; --i) {
        const auto& p = pts[i];
        while (upper.size() >= 2 && cross(upper[upper.size()-2], upper.back(), p) <= 0) {
            upper.pop_back();
        }
        upper.push_back(p);
    }
    lower.pop_back();
    upper.pop_back();
    vector<Pt> hull = lower;
    hull.insert(hull.end(), upper.begin(), upper.end());
    return hull;
}

pll diam(const vector<Pt>& h) {
    ll m = h.size();
    if (m == 1) return {0, 0};
    if (m == 2) return {0, 1};
    ll best = 0;
    pll ans = {0, 1};
    ll j = 1;
    for (ll i = 0; i < m; ++i) {
        ll ni = (i + 1) % m;
        while ( llabs(cross(h[i], h[ni], h[(j+1)%m])) > llabs(cross(h[i], h[ni], h[j])) ) {
            j = (j + 1) % m;
        }
        ll d1 = dist2(h[i], h[j]);
        if (d1 > best) { best = d1; ans = {i, j}; }
        ll d2 = dist2(h[ni], h[j]);
        if (d2 > best) { best = d2; ans = {ni, j}; }
    }
    return ans;
}

void solve() {
    ll n;
    cin >> n;
    vector<Pt> pts(n);
    for (ll i = 0; i < n; ++i) cin >> pts[i].x >> pts[i].y;
    
    vector<Pt> hull = func(pts);

    if (hull.size() == 1) {
        ll a = 1, b = 0;
        ll c = -(a*hull[0].x + b*hull[0].y);
        cout << a << " " << b << " " << c << "\n";
        cout << a << " " << b << " " << c << "\n";
        return;
    }
    if (hull.size() == 2) {
        Pt p = hull[0], q = hull[1];
        ll a = q.x - p.x;
        ll b = q.y - p.y;
        ll c1 = -(a*p.x + b*p.y);
        ll c2 = -(a*q.x + b*q.y);
        cout << a << " " << b << " " << c1 << "\n";
        cout << a << " " << b << " " << c2 << "\n";
        return;
    }

    auto [i, j] = diam(hull);
    Pt p = hull[i], q = hull[j];

    ll a = q.x - p.x;
    ll b = q.y - p.y;
    ll c1 = -(a*p.x + b*p.y);
    ll c2 = -(a*q.x + b*q.y);

    if (a < 0 || (a == 0 && b < 0)) {
        a = -a; b = -b; c1 = -c1; c2 = -c2;
    }

    cout << a << " " << b << " " << c2 << "\n";
    cout << a << " " << b << " " << c1 << "\n";
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    // freopen("", "r", stdin);
    // freopen("", "w", stdout);

    int t = 1;
    // cin >> t;
    while (t--) solve();
    return 0;
}