#include <bits/stdc++.h>
// #pragma comment(linker, "/STACK:16777216")
// #pragma GCC optimize("O3,unroll-loops")
// #pragma GCC target("avx2,sse4,fma,bmi,bmi2,popcnt,lzcnt,abm,tune=native")

using namespace std;
using uint = unsigned int;
using ll = long long;
using ull = unsigned long long;
using dbl = double;
using ld = long double;
using vll = vector<long long>;
using pi = pair<int, int>;
using pll = pair<ll, ll>;
using pd = pair<dbl, dbl>;
using pld = pair<ld, ld>;

#define ft first
#define sc second
#define pb push_back
#define all(x) (x).begin(), (x).end()
#define rall(x) (x).rbegin(), (x).rend()

template<typename T>
T modpow(T base, T exp, T modulus) {
    base %= modulus;
    T result = 1;
    while (exp > 0) {
        if (exp & 1) result = (result * base) % modulus;
        base = (base * base) % modulus;
        exp >>= 1;
    }
    return result;
}

void solve(ll p, ll m, const vll& fact, const vll& inv) {
    ll mod = 1e9 + 7;
    auto c = [&](ll n, ll k) -> ll {
        return fact[n] * inv[k] % mod * inv[n - k] % mod;
    };

    ll comb = c(2 * p, p);

    ll ans = modpow(4LL, p, mod) * modpow(comb, mod - 2, mod) % mod;
    ll n = 2 * p + m;
    ans = ans * (n + 1) % mod * modpow(2 * p + 1, mod - 2, mod) % mod;

    cout << ans << '\n';
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    ll mod = 1e9 + 7;
    // freopen("", "r", stdin);
    // freopen("", "w", stdout);

    int t = 1;
    cin >> t;

    vector<pll> ps(t);
    ll lim = 0;
    for (int i = 0; i < t; i++) {
        ll p, m;
        cin >> p >> m;
        ps[i] = {p, m};
        lim = max(lim, p);
    }

    ll limit = 2 * lim;
    vll fact(limit + 1);
    vll inv(limit + 1);
    fact[0] = 1;
    for (int i = 1; i <= limit; i++) {
        fact[i] = fact[i - 1] * i % mod;
    }
    inv[limit] = modpow(fact[limit], mod - 2, mod);
    for (ll i = limit - 1; i >= 0; i--) {
        inv[i] = inv[i + 1] * (i + 1) % mod;
    }
    for (int i = 0; i < t; i++) solve(ps[i].ft, ps[i].sc, fact, inv);
    return 0;
}
