def can_play(s):
    notes = {}
    for note in "ABCDEFG":
        idx = ord(note) - ord("A")
        notes[note] = [p for p in range(52) if p % 7 == idx]

    cur = notes[s[0]]

    for i in range(1, len(s)):
        nxt_note = s[i]
        nxt_set = set()

        for pos in cur:
            for d in (-3, -2, -1, 0, 1, 2, 3):
                new_pos = pos + d
                if 0 <= new_pos < 52 and new_pos % 7 == (ord(nxt_note) - ord("A")):
                    nxt_set.add(new_pos)

        if not nxt_set:
            return "No"
        cur = list(nxt_set)
    return "Yes"

t = int(input())
for _ in range(t):
    melody = input().strip()
    print(can_play(melody))
