import sys
from sys import stdout
  
def count_digits(n):
    return len(str(n))
  
def estimate_cost(n, max_depth=16):
    cost = 0
    current = n
    depth = 0

    while current != 1 and depth < max_depth:
        if current % 2 == 0:
            next_val = current // 2
        else:
            next_val = 3 * current + 1
          
        cost += count_digits(next_val)
        current = next_val
        depth += 1
          
        if current in cost_cache and depth < max_depth:
            cost += cost_cache[current]
            break
      
    if depth < max_depth:
        cost_cache[n] = cost
      
    return cost
  
cost_cache = {}
  
t = int(input())
  
for _ in range(t):
    n = int(input())

    while n != 1:
        cost = estimate_cost(n)

        cost_threshold = 707

        if cost > cost_threshold:
            if n % 2 == 0:
                print("collatz")
                stdout.flush()
                n = n // 2
                continue

            if n < 10_000_000:
                print("random")
                stdout.flush()
            else:
                print("collatz")
                stdout.flush()
                n = n // 2
                continue
        else:
            print("collatz")
            stdout.flush()
          
        n = int(input())
        if n == 0:
            sys.exit(0)